#!/bin/bash

INST_UPDATE=1
DEST_BIN_DIR="/usr/local/bin/ioserver/"
SERVICE_NAME="ioserver.service"
SERVICE_FILE="/etc/systemd/system/${SERVICE_NAME}"

BIN_NAME="IOServer"
SRC_BIN_FILE="${BIN_NAME}"

if [[ ! -f ${SERVICE_FILE} ]]; then
	echo "install as new"
	INST_UPDATE=0
else
	echo "install as update"
	systemctl stop ${SERVICE_NAME}
	sleep 2
	systemctl disable ${SERVICE_NAME}
fi

if [[ ! -d ${DEST_BIN_DIR} ]]; then
	INST_UPDATE=0
	mkdir -p ${DEST_BIN_DIR}
else
	INST_UPDATE=1
fi

cp -v ${SERVICE_NAME} ${SERVICE_FILE}
systemctl enable ${SERVICE_NAME}
systemctl daemon-reload
	
chmod +x ${SRC_BIN_FILE}
chmod +x IODblink
chmod +x IODevice

cp -v ${SRC_BIN_FILE} ${DEST_BIN_DIR}
cp -v IODblink ${DEST_BIN_DIR}
cp -v IODevice ${DEST_BIN_DIR}
cp -v librdbapix64.so ${DEST_BIN_DIR}
cp -v mime.ini ${DEST_BIN_DIR}

if [[ ${INST_UPDATE} == 0 ]]; then
	cp -rv drivers ${DEST_BIN_DIR}
	cp -rv config ${DEST_BIN_DIR}
	cp -rv httpdoc ${DEST_BIN_DIR}

	echo -e "install success."
else	
	cp -rv drivers ${DEST_BIN_DIR}
	
	read -p "over write config, yes/no ?, [n]:" COPY_CONFIG
	if [[ $COPY_CONFIG == 'y' || $COPY_CONFIG == 'Y' || $COPY_CONFIG == 'yes' ]]; then
		cp -rv config ${DEST_BIN_DIR}
	fi
	
	read -p "over write httpdoc, yes/no ?, [n]:" COPY_HTTP
	if [[ $COPY_HTTP == 'y' || $COPY_HTTP == 'Y' || $COPY_HTTP == 'yes' ]]; then
		cp -rv httpdoc ${DEST_BIN_DIR}
	fi	

	echo -e "update success."
fi

echo -e "please run\n   sudo systemctl start ${SERVICE_NAME} \nto start ioserver"






