﻿/*!
io-server的websocket登录连接
\update 2022.4.27
\author jiangyong
*/
var info_page_footer = "IOServer manager 5.0.3 <a href=\"http://www.kipway.com\">重庆唐码软件有限公司</a>©2009-2023 ";
var _wsurl = null; //连接URL, 比如 wss://127.0.0.1
var _wsusr = null;   //用户名
var _wspsw = null;   //密码
var _wsobject = null;  // WS连接对象
var _loginst = false;  //当前登录状态

var g_seqno = 0; // 全局连续递增的序列号，仅供nextseqno使用，不要直接使用。

const funid_login_req = 1001;
const funid_login_resp = 1002;
/**
 * 获取下一个seqno号,1到MAXINT32之间
 * @return {number} 返回整数
 * */
function nextseqno() {
	g_seqno++;
	if (g_seqno === 2147483647)
		g_seqno = 1;
	return g_seqno;
}

/**
 * 异步登录,创建WS连接,保存登录参数,在rdbws_onopen里发送登录请求.
 * @param {string} wsurl 实时库连接地址,WSS://127.0.0.1
 * @param {string} usr  用户名
 * @param {string} psw  用户密码
 * @return {boolean} 返回连接成功
 */
function ws_connect(wsurl, usr, psw) {
	_loginst = false;
	try {
		_wsurl = wsurl;
		_wsusr = usr;
		_wspsw = psw;

		_wsobject = new WebSocket(_wsurl, "json");
		_wsobject.onopen = ws_onopen;
		_wsobject.onmessage = ws_onmessage;
		_wsobject.onclose = ws_onclose;
		return true;
	}
	catch (e) {
		console.log("Login do Err:", e);
		return false;
	}
}

function ws_islogin() {
	return _loginst;
}

/*!
\brief 登出
断开连接，清空会话存储的URL,USR,PSW,SUBP参数
*/
function ws_disconnet() {
	try {
		sessionStorage.removeItem("_ssdbpwsurl");
		sessionStorage.removeItem("_ssdbpwsusr");
		sessionStorage.removeItem("_ssdbpwspswd");
		if (_wsobject) {
			_wsobject.close();
			_wsobject = null;
		}
		_loginst = false;
	}
	catch (e) {
		console.log("ws_disconnet Err:", e);
	}
}

/**
 * WS连接回调处理,发送登录消息。
 * @param {object} event ws事件
 */
function ws_onopen(event) {
	let oreq = {};
	let head = {};
	let body = {};
	head.ver = 300;
	head.funid = funid_login_req;
	head.seqno = nextseqno();

	body.username = _wsusr;
	body.userpswd = _wspsw;
	
	oreq.msghead = head;
	oreq.msgbody = body;
	ws_send(JSON.stringify(oreq));
}

/**
 * 处理WS接受消息
 * @param {object} event ws事件
 */
function ws_onmessage(event) {
	if (typeof OnWsMessage === "function") {
		OnWsMessage(event);//应用层可以实现这个函数获得原始消息
	}
	try {
		var msg = JSON.parse(event.data);
		if (!("msghead" in msg) || !("funid" in msg.msghead) || msg.msghead.ver !== 300)
			return;
		
		if (msg.msghead.funid === funid_login_resp) {
			if (!msg.msgbody.retcode) { //登录成功
				console.log("login success!", msg);
				sessionStorage.setItem("_ssdbpwsurl", _wsurl);
				sessionStorage.setItem("_ssdbpwsusr", _wsusr);
				sessionStorage.setItem("_ssdbpwspswd", _wspsw);
				if (typeof onlogin_st === "function")
					onlogin_st(true);
				_loginst = true;
			}
			else {
				console.log("login failed:", msg);
				if (typeof onlogin_st === "function") {
					onlogin_st(false);
					_wsobject.close();
					_wsobject = null;
				}
			}
		}
		else {
			if (typeof OnMsgReadData === "function")
				OnMsgReadData(msg); //其他数据
		}
	}
	catch (e) {
		console.log("ws_onmessage do exception:", e);
	}
}

/**
 * WS连接断开事件处理,可以在这里面做断线重连.
 * @param {object} event WS事件
 */
function ws_onclose(event) {
	if (event.target != _wsobject)
		return;
	console.log("ws_onclose", event);
	_loginst = false;
	if (typeof on_wsclosed === "function")
		on_wsclosed(event);
}

/**
 * 发送JSON字符串。
 * @param {string} str  需要发送的字符串
 * @return {boolean} true:success;  false:failed;
 */
function ws_send(str) {
	try {
		if (_wsobject === null || _wsobject.readyState !== _wsobject.OPEN)
			return false;
		_wsobject.send(str);
	} catch (e) {
		return false;
	}
	return true;
}

/**
 * 自动连接,连接参数存储在sessionStorage里面。
 * @return {Boolean} 返回创建连接成功
 * */
function ws_autologin() {
	if (!_wsobject) {
		try {
			var wsurl = sessionStorage.getItem("_ssdbpwsurl");
			var usr = sessionStorage.getItem("_ssdbpwsusr");
			var psw = sessionStorage.getItem("_ssdbpwspswd");
			if (!wsurl || !usr || !psw)
				return false;
			return ws_connect(wsurl, usr, psw);
		} catch (e) {
			console.log("ws_connect Err:", e);
			return false;
		}
	}
}


/**
 * 检测是不是IE浏览器
 * */
function jt_isie() {
	var Sys = {};
	var ua = navigator.userAgent.toLowerCase();
	var s;
	(s = ua.match(/rv:([\d.]+)\) like gecko/)) ? Sys.ie = s[1] :
		(s = ua.match(/msie ([\d.]+)/)) ? Sys.ie = s[1] :
			(s = ua.match(/firefox\/([\d.]+)/)) ? Sys.firefox = s[1] :
				(s = ua.match(/chrome\/([\d.]+)/)) ? Sys.chrome = s[1] :
					(s = ua.match(/opera.([\d.]+)/)) ? Sys.opera = s[1] :
						(s = ua.match(/version\/([\d.]+).*safari/)) ? Sys.safari = s[1] : 0;
	if (Sys.ie) alert("此页面不支持IE浏览器,请使用chrome或firefox");
}


