#!/bin/bash

INST_UPDATE=1
DEST_BIN_DIR="/usr/local/bin/logsrv/"
SERVICE_NAME="logsrv.service"
SERVICE_FILE="/etc/systemd/system/${SERVICE_NAME}"
if [[ ! -f ${SERVICE_FILE} ]]; then
	echo "install as new"
	INST_UPDATE=0
    mkdir -p ${DEST_BIN_DIR}
    cp -v ${SERVICE_NAME} ${SERVICE_FILE}
    systemctl enable ${SERVICE_NAME}
    systemctl daemon-reload
fi

BIN_NAME="logsrv"
SRC_BIN_FILE="${BIN_NAME}"

#if running, stop it
if [[ "XX`pidof ${BIN_NAME}`" != "XX" ]]; then
	INST_UPDATE=1
	echo "install as update"
	echo "${BIN_NAME} is running, stop it."
	systemctl stop ${SERVICE_NAME}
    echo "${SERVICE_NAME} stopped."
	sleep 2
fi

chmod +x ${SRC_BIN_FILE}

cp -v ${SRC_BIN_FILE} ${DEST_BIN_DIR}
if [[ ${INST_UPDATE} == 0 ]]; then
	cp -v logsrv.ini ${DEST_BIN_DIR}
	cp -v mime.ini ${DEST_BIN_DIR}
	cp -v loguser.json ${DEST_BIN_DIR}
	cp -rv httpdoc ${DEST_BIN_DIR}
	echo -e "install success."	
else	
	read -p "over write httpdoc, yes/no ?, [y]:" COPY_HTTP
	if [[ -z $COPY_HTTP || $COPY_HTTP == 'y' || $COPY_HTTP == 'Y' || $COPY_HTTP == 'yes' ]]; then
		cp -rv httpdoc ${DEST_BIN_DIR}
	fi	
	echo -e "update success."
fi

echo "start ${BIN_NAME}"
systemctl start ${BIN_NAME}
${DEST_BIN_DIR}${BIN_NAME} -status





