﻿/// <summary>
/// real-time database C#接口,从C接口直接翻译而来,用法和C接口完全一致,具体使用说明请参阅rdbapi.chm文件.
/// 如果您是资深的C#程序员，请不要使用这个API，应该使用通信协议《rdb_data_exchange_protocol.pdf》直接和实时库交互。
/// </summary>
namespace rdb
{
    public partial class def
    {
        public const int DT_VOID = 0;
        public const int DT_DIGITAL = 1;
        public const int DT_INT32 = 2;
        public const int DT_FLOAT32 = 3;
        public const int DT_INT64 = 4;
        public const int DT_FLOAT64 = 5;
        public const int DT_STRING = 6;
        public const int DT_OBJECT = 7;

        public const int TGCLS_DEC = 0;
        public const int TGCLS_DEFINE = 1;
        public const int TGCLS_PRESET = 2;
        public const int TGCLS_CURVE = 3;

        public const int TA_COMPNO = 0;
        public const int TA_COMPPER = 1;
        public const int TA_COMPVAL = 2;

        public const int QA_OK = 0;
        public const int QA_SHUTDOWN = 1;
        public const int QA_ERRDATA = 2;
        public const int QA_NOTAG = 3;
        public const int QA_ERRTIME = 4;

        public const int OPT_POW_READ = 1;
        public const int OPT_POW_WRITE = 2;
        public const int OPT_POW_WTAG = 4;
        public const int OPT_POW_MAN = 8;
        public const int OPT_POW_CTRL = 16;

        public const int TAG_MASK_DES = 1;
        public const int TAG_MASK_UNIT = 2;
        public const int TAG_MASK_COMPEXC = 8;
        public const int TAG_MASK_CLASS = 16;
        public const int TAG_MASK_ARCHIVE = 32;
        public const int TAG_MASK_VDIGITS = 64;
        public const int TAG_MASK_STEP = 128;
        public const int TAG_MASK_LIMIT = 256;
        public const int TAG_MASK_BKSYN = 512;
        public const int TAG_MASK_ALARM = 1024;

        public const int TAGIN_NOTMODIFY = 0;
        public const int TAGIN_MODIFY = 1;
        public const int TAGIN_ADD = 2;

        public const int SECTION_INSERT = 0;
        public const int SECTION_AFTER = 1;
        public const int SECTION_BEFORE = -1;

        public const int MAX_OBJ_LEN = 1000;

        public const int SE_ERRHANDLE = -1;

        public const int DBR_SUCCESS = 0;
        public const int SE_OK = 0;
        public const int SE_SUCCESS = 0;

        public const int SE_FAILED = 1;
        public const int SE_TCP_CONNECT = 2;
        public const int SE_TCP_PROXY_CONNECT = 3;
        public const int SE_TCP_PROXY_AUTH = 4;
        public const int SE_TCP_DISCONNECT = 5;
        public const int SE_TCP_IO = 6;
        public const int SE_TCP_CONSVRFAIL = 7;
        public const int SE_TCP_SENDBLOCK = 8;
        public const int SE_TCP_ERRPKG = 10;
        public const int SE_TCPCALLTIMEOUT = 11;
        public const int SE_ERRARGS = 12;
        public const int SE_EXP = 16;
        public const int SE_EXPVAR = 17;
        public const int SE_EXPVAROVER = 18;
        public const int SE_BUSY = 19;
        public const int SE_NOTCONNECT = 31;
        public const int SE_OPT_OK = 0;
        public const int SE_OPT_NOACTOR = 32;
        public const int SE_OPT_NOUSER = 33;
        public const int SE_OPT_PASSERR = 34;
        public const int SE_OPT_NOPOWER = 35;
        public const int SE_OPT_USEREXIST = 36;
        public const int SE_OPT_ACTOREXIST = 37;
        public const int SE_OPT_ACTORUSE = 38;
        public const int SE_OPT_NOLOGIN = 39;
        public const int SE_OPT_NOTACTIVE = 40;
        public const int SE_OPT_OPTFULL = 41;
        public const int SE_OPT_ACTFULL = 42;
        public const int SE_TG_NOTAG = 48;
        public const int SE_TG_TAGFULL = 49;
        public const int SE_TG_NOARCHIVE = 50;
        public const int SE_DA_TIME = 64;
        public const int SE_DA_TYPE = 65;
        public const int SE_DA_QA = 66;
        public const int SE_DA_NODATA = 67;
        public const int SE_CTRLNOROUTE = 97;
        public const int SE_CTRLOUTERR = 98;
        public const int SE_SRV_FRMNOOD = 255;
        public const int SE_SRV_FRMERR = 254;
        public const int SE_SRV_DBVER = 253;
        public const int SE_SRV_BACKUOPSRV = 251;
        public const int SE_SRV_DEMOOVER = 252;

        public const int MSGCODE_CONNECT_SUCCESS = 60001;
        public const int MSGCODE_CONNECT_FAILED = 60002;
        public const int MSGCODE_DISCONNECTED = 60003;
    }

    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, CharSet = System.Runtime.InteropServices.CharSet.Ansi)]
    public struct rec_tag
    {
        public uint uid;
        public byte cdatatype;
        public byte ctagtype;
        public byte ccomptype;
        public byte cres;
        public float fcompval;
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 80)]
        public string sname;
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 80)]
        public string sdes;
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 16)]
        public string sunit;
        public byte cdigits;
        public byte cclass;
        public byte cstep;
        public byte carchive;
        public float fdnval;
        public float fupval;
        public float fexcdev;
        public short snexcmin;
        public short snexcmax;
        public short sncompmin;
        public short sncompmax;
        public int alarmtype;
        public float alarm_llv;
        public float alarm_lv;
        public float alarm_hv;
        public float alarm_hhv;
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 24)]
        public string sres;
    }

    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Explicit)]
    public struct unionval
    {
        [System.Runtime.InteropServices.FieldOffsetAttribute(0)]
        public int i32;
        [System.Runtime.InteropServices.FieldOffsetAttribute(0)]
        public float f32;
        [System.Runtime.InteropServices.FieldOffsetAttribute(0)]
        public long i64;
        [System.Runtime.InteropServices.FieldOffsetAttribute(0)]
        public double f64;
        [System.Runtime.InteropServices.FieldOffsetAttribute(0)]
        public ulong u64;
    }

    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
    public struct rec_val
    {
        public long time;
        public unionval v;
        public byte cvt;
        public byte cqa;
        public byte cerr;
        public byte cres;
        public uint unres;
    }

    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, CharSet = System.Runtime.InteropServices.CharSet.Ansi)]
    public struct rec_tagval
    {
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 80)]
        public string sname;
        public rec_val val;
    }

    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, CharSet = System.Runtime.InteropServices.CharSet.Ansi)]
    public struct rec_obj
    {
        public long time;
        public uint uobjtype;
        public uint ures;
        public byte cvt;
        public byte cqa;
        public byte cerr;
        public byte cres;
        public ushort usres;
        public ushort uslen;
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 1000)]
        public string sdata;
    }

    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, CharSet = System.Runtime.InteropServices.CharSet.Ansi)]
    public struct rec_tagobj
    {
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 80)]
        public string sname;
        public rec_obj var;
    }

    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, CharSet = System.Runtime.InteropServices.CharSet.Ansi)]
    public struct rec_operator
    {
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 16)]
        public string sname;
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 16)]
        public string smd5pass;
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 16)]
        public string sactor;
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 80)]
        public string sdes;
        public int lbactive;
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 28)]
        public string sres;
    }

    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, CharSet = System.Runtime.InteropServices.CharSet.Ansi)]
    public struct rec_actor
    {
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 16)]
        public string sname;
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 80)]
        public string sdes;
        public uint dwpower;
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 28)]
        public string sres;
    }

    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, CharSet = System.Runtime.InteropServices.CharSet.Ansi)]
    public struct rec_soe
    {
        public long time;
        public uint uautokey;
        public int type;
        public short argtype;
        public ushort arglen;
        public int level;
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 80)]
        public string source;
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 160)]
        public string sdes;
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 240)]
        public string sarg;
        public byte cflag;
        public byte cstatus;
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 6)]
        public string res;
    }

    [System.Runtime.InteropServices.UnmanagedFunctionPointer(System.Runtime.InteropServices.CallingConvention.Cdecl)]
    public delegate bool rdbcb_OnReadTags(
        [System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.LPArray,SizeParamIndex = 1),
        System.Runtime.InteropServices.In]  rec_tag[] ptags,
        int nitems,
        System.IntPtr pParam);

    [System.Runtime.InteropServices.UnmanagedFunctionPointer(System.Runtime.InteropServices.CallingConvention.Cdecl)]
    public delegate bool rdbcb_OnReadVals(
        [System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.LPArray, SizeParamIndex = 1),
        System.Runtime.InteropServices.In]  rec_val[] pvals,
        int nitems, System.IntPtr pParam);

    [System.Runtime.InteropServices.UnmanagedFunctionPointer(System.Runtime.InteropServices.CallingConvention.Cdecl)]
    public delegate bool rdbcb_OnReadObjs(
        [System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.LPArray, SizeParamIndex = 1),
        System.Runtime.InteropServices.In]  rec_obj[] pobjs,
        int nitems, System.IntPtr pParam);

    [System.Runtime.InteropServices.UnmanagedFunctionPointer(System.Runtime.InteropServices.CallingConvention.Cdecl)]
    public delegate bool rdbcb_OnReadSoes(
        [System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.LPArray, SizeParamIndex = 1),
        System.Runtime.InteropServices.In]  rec_soe[] psoes,
        int nitems, System.IntPtr pParam);

    [System.Runtime.InteropServices.UnmanagedFunctionPointer(System.Runtime.InteropServices.CallingConvention.Cdecl)]
    public delegate bool ctrl_OnValWriteToDevice(ref rec_tagval pval, System.IntPtr pParam);

    [System.Runtime.InteropServices.UnmanagedFunctionPointer(System.Runtime.InteropServices.CallingConvention.Cdecl)]
    public delegate bool ctrl_OnObjWriteToDevice(ref rec_tagobj pobj, System.IntPtr pParam);

    [System.Runtime.InteropServices.UnmanagedFunctionPointer(System.Runtime.InteropServices.CallingConvention.Cdecl)]
    public delegate void rdbcd_onmessage(int nmsgcode, [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string smsg, System.IntPtr param);


    public partial class dbi
    {

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_create",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_create();

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_destory",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_destory(int h);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_connect",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_connect(int h,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string sServerIP,
            ushort wPort,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string lpszUser,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string lpszPass);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_connectex",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_connectex(int h,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string sUrl,            
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string lpszUser,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string lpszPass,
            int nTimeOutSec
            );

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_connectasyn",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_connectasyn(int h,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string sServerIP,
            ushort wPort,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string lpszUser,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string lpszPass);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_disconnect",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_disconnect(int h);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_isconnected",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        [return: System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.I1)]
        public static extern bool rdb_isconnected(int h);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_actoradd",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_actoradd(int h, ref rec_actor pa);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_actordel",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_actordel(int h,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string sname);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_actorsget",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_actorsget(int h,
            [System.Runtime.InteropServices.Out] rec_actor[] actors, int nrecbufsize, ref int pnacts);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_operatoradd",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_operatoradd(int h, ref rec_operator po);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_operatordel",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_operatordel(int h,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string sname);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_operatorsget",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_operatorsget(int h,
            [System.Runtime.InteropServices.Out] rec_operator[] opts,
            int nrecbufsize,
            ref int pnopts);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_operatormodifypass",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_operatormodifypass(int h,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string sname,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string soldpass,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string snewpass);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_taginport",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_taginport(int h, uint dwflag, ref rec_tag ptag, ref int presult);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_tagget",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_tagget(int h, ref rec_tag ptag);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_tagdel",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_tagdel(int h,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string sname);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_tagquery",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_tagquery(int h,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string snamefilter,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string sdesfilter,
            int ndatatype,
            int ntagclass,
            rdbcb_OnReadTags pfun,
            System.IntPtr pParam);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_valputsnapshot",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_valputsnapshot(int h,
            [System.Runtime.InteropServices.In, System.Runtime.InteropServices.Out] rec_tagval[] vals,
            int nsize);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_valgetsnapshot",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_valgetsnapshot(int h,
            [System.Runtime.InteropServices.In, System.Runtime.InteropServices.Out] rec_tagval[] vals,
            int nsize);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_valinsert",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_valinsert(int h, rec_tagval[] vals, int nsize);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_valgetsection",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_valgetsection(int h,
            long ltime,
            int nflag,
            [System.Runtime.InteropServices.In, System.Runtime.InteropServices.Out] rec_tagval[] vals,
            int nsize);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_valquery",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_valquery(int h,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string sname,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string sexp,
            long lts,
            long lte,
            long lds,
            int lflag,
            rdbcb_OnReadVals pfun,
            System.IntPtr pParam);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_objputsnapshot",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_objputsnapshot(int h,
            [System.Runtime.InteropServices.In, System.Runtime.InteropServices.Out] rec_tagobj[] pobjs,  int nsize);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_objgetsnapshot",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_objgetsnapshot(int h,
            [System.Runtime.InteropServices.In, System.Runtime.InteropServices.Out] rec_tagobj[] pobjs,
            int nsize);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_objinsert",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_objinsert(int h, rec_tagobj[] pobjs,  int nsize);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_objget",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_objget(int h,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string stagname,
            long lts,
            long lte,
            rdbcb_OnReadObjs pfun,
            System.IntPtr pParam);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_soeput",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_soeput(int h, rec_soe[] psoe,   int nsize);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_soequery",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi, CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_soequery(int h,
            long lts,
            uint autokey,
            long lte,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string sexp,
            rdbcb_OnReadSoes pfun,
            System.IntPtr pParam);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_soeupdate",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_soeupdate(int h,
            [System.Runtime.InteropServices.In, System.Runtime.InteropServices.Out] rec_soe[] psoe,
            int nsize);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_countvalue",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_countvalue(int h,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string sname,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string sexp,
            long lts,
            long lte,
            ref rec_val pMin,
            ref rec_val pMax,
            ref double pavg,
            ref double psum,
            ref int plrecs);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rbd_countstatuschang",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rbd_countstatuschang(int h,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string sname,
            long lts,
            long lte,
            int nlowval,
            int nhighval,
            ref int pnl2h,
            ref int pnh2l);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_countvaltime",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_countvaltime(int h,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string sname,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string sexp,
            long lts,
            long lte,
            ref long pltime,
            ref int plrecs);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_time",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern long rdb_time();

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_localtime2rdbtime",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern long rdb_localtime2rdbtime(int nyear, int nmon, int nday, int nhour, int nmin, int nsec, int nmsec);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_rdbtime2localtime",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        [return: System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.I1)]
        public static extern bool rdb_rdbtime2localtime(long ltime, ref int pnyear, ref int pnmon, ref int pnday, ref int pnhour, ref int pnmin, ref int pnsec, ref int pnmsec);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_initwritetodevice",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_initwritetodevice(int h, ctrl_OnValWriteToDevice funvalw, System.IntPtr paramvalw, ctrl_OnObjWriteToDevice funobjw, System.IntPtr paramobjw);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_regctrltag",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_regctrltag(int h,
            [System.Runtime.InteropServices.InAttribute()] [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.LPStr)] string stagname);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_writevaltodevice",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_writevaltodevice(int h, ref rec_tagval pval);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_writeobjtodevice",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_writeobjtodevice(int h, ref rec_tagobj pobj);

        [System.Runtime.InteropServices.DllImportAttribute("rdbapi.dll", EntryPoint = "rdb_setmessagenotify",
            CharSet = System.Runtime.InteropServices.CharSet.Ansi,
            CallingConvention = System.Runtime.InteropServices.CallingConvention.Cdecl)]
        public static extern int rdb_setmessagenotify(int h, rdbcd_onmessage fun, System.IntPtr param);

    }
}
