/*!
\file test_ctrlout.js
批量写设备例子,将一个设备的标签用控制输出的方式写入另一个设备
*/

global g_cfg = []; //vector配置表
global g_jobname = "test_ctrlout";

function logflag() //日志标志，用于在日志中却分是哪个脚本产生的日志
{
	return "[" + g_jobname + "] ";
}

function init() //初始化标签表
{		
	g_cfg.push_back(["src.ir01",  "target.iw01",  "i32"]); //按照源标签名，目标标签名，类型顺序("i32","i64","f32","f64"这4种之一)
	g_cfg.push_back(["src.fr02",  "target.fw02",  "f32"]);		
	g_cfg.push_back(["src.lr03",  "target.lw03",  "i64"]);
	g_cfg.push_back(["src.dblr04","target.dblw04","f64"]);	
}

function writeonetag(string stag,string dtag,string type)
{
	var vr = rdb_getsnapval(stag); //先读取源标签值
	if(vr.qa !=0 && vr.qa != 1){
		logout("msg",logflag() + "getsnapval(" + stag + ") failed. QA = " + vr.qa.to_string());
		return ; //0(OK) 和 1(shutdown)才可用，其他的 不写
	}	
	var vw;
	if(type == "i32"){
		vw = vr.iv;		
	}	
	else if(type == "f32"){
		vw = vr.fv;		
	}
	else if(type == "f64"){
		vw = vr.dblv;		
	}
	else if(type == "i64"){
		vw = vr.lv;		
	}	
	else{
		logout("err",logflag() + "writedevice(" + dtag + ") error type = " + type);
	}
	var nret = rdb_writedevice(dtag, vw);
	if(nret != 0){
		logout("err",logflag() + "writedevice(" + dtag + ") error " + nret.to_string());
	}
	else{
		logout("dbg",logflag() + "writedevice(" + dtag + ") success, val = " + vw.to_string());
	}
}

function run() // 主运行函数,按照配置定时或者周期性被执行，注意不要有间接或者直接死循环在里面。
{		
	for( var i = 0; i < g_cfg.size(); ++i){
		writeonetag(g_cfg[i][0],g_cfg[i][1],g_cfg[i][2]);		
	}
}

init(); //初始化只会执行一次
