﻿/*!
\file dbv_ws.js
\author jiangyong

应用层实现这些函数
dbv_OnLogin(bstatus) //登录结果通知，bstatus = true表示登录成功，false表示登录失败
dbv_OnNoLogin()  //当前没有连接，用于自动连接时通知
dbv_OnReadEvent(event) //可选,ws_onmessage收到的事件，用于调试
dbv_OnReadData(cls) //接受数据处理，cls是一个josn对象

*/
var _dbv_ws = null;

var _dbv_url = null;
var _dbv_usr = null;
var _dbv_psw = null;
var _dbv_protocol = null;
var _dbv_status = false;
/*!
\brief 登录
使用URL,USR,PSW参数创建一个WebSocket对象连接服务,并保存登陆参数到全局变量_dbv_url,_dbv_usr,_dbv_psw
\param url WS或WSS地址;格式 "ws:192.168.1.41:8087" 或 "wss:192.168.1.41:8086"
\param usr 用户账号
\param psw 密码
\param subp 子协议
*/
function dbv_login(url, usr, psw, subp) {
    try {
        _dbv_url = url;
        _dbv_usr = usr;
        _dbv_psw = psw;
        _dbv_protocol = subp;
        _dbv_ws = new WebSocket(url, subp);
        _dbv_ws.onopen = dbvws_onopen;
        _dbv_ws.onmessage = dbvws_onmessage;
        _dbv_ws.onclose = dbvws_onclose;
    }
    catch (e) {
        console.log("dbv_login Err:", e);
    }
}

/*!
\brief 自动登录
从会话存储中获取登录成功时保存的URL,USR,PSW参数直接登录。
*/
function dbv_autologin() {
    try {
        var url = sessionStorage.getItem("s_dbv_url");
        var usr = sessionStorage.getItem("s_dbv_usr");
        var psw = sessionStorage.getItem("s_dbv_psw");
        var subp = sessionStorage.getItem("s_dbv_subp");
        if (url != null && usr != null && psw != null && subp != null)
            dbv_login(url, usr, psw, subp);
        else {
            if (typeof (dbv_OnNoLogin) == "function")
                dbv_OnNoLogin(); //应用层提供
        }
    }
    catch (e) {
        console.log("dbv_autologin Err:", e);
    }
}

/*!
\brief 连接成功后发送登陆命令
*/
function dbvws_onopen(event) {
    try {
        _dbv_ws.send("login," + _dbv_usr);
    }
    catch (e) {
        console.log("dbvws_onopen send Err:", e);
    }
};

/*!
\brief 处理接收到的信息
*/
function dbvws_onmessage(event) {
    try {
        if (typeof (dbv_OnReadEvent) == "function")
            dbv_OnReadEvent(event); //应用层提供,调试用
        var cls = JSON.parse(event.data);
        if (cls.order == "onlogin") {
            if (cls.errcode != 0) {
                console.log("onlogin Err:", cls);
                dbv_OnLogin(false);
                return;
            }
            var sauth = "auth," + hex_md5(cls.vals + hex_md5(_dbv_psw).toUpperCase()).toUpperCase();
            _dbv_ws.send(sauth);
        }
        else if (cls.order == "onauth") {
            if (cls.errcode != 0) {
                console.log("onauth Err:", cls);
                dbv_OnLogin(false);
            }
            else {
                console.log("login success!", cls);
                sessionStorage.setItem("s_dbv_url", _dbv_url); //保存登录参数到当前会话
                sessionStorage.setItem("s_dbv_usr", _dbv_usr);
                sessionStorage.setItem("s_dbv_psw", _dbv_psw);
                sessionStorage.setItem("s_dbv_subp", _dbv_protocol);
                dbv_onlogin(true);
            }
        }
        else {
            if (cls.seqno > 0 && typeof (dbv_OnReadData) == "function") {
                try {
                    dbv_OnReadData(cls); //应用层提供,处理接收到的数据
                }
                catch (e) { }                
            }
        }
    }
    catch (e) {
        console.log("dbvws_onmessage do Err:", e);
    }
};

function dbvws_onclose(event) {
    _dbv_status = false;
    console.log("ws_onclose", event);
    if (typeof (dbv_OnClose) == "function")
        dbv_OnClose(event); //应用层提供  
};


/*!
\brief 登陆状态通知
其中的dbv_OnLogin由应用层提供
\param  st  bool型，true表示登陆成功，false表示登录失败
*/
function dbv_onlogin(st)//登录状态
{
    try {
        _dbv_status = st;
        if (typeof (dbv_OnLogin) == "function")
            dbv_OnLogin(st); //应用层提供
    } catch (e) {
    }
}

var g_dbvseqno = 0;

/*!
\brief 获取不为0的全局递增序号用于发送命令中的seqno
*/
function dbv_getseqno() {
    g_dbvseqno++;
    if (g_dbvseqno == 0)
        g_dbvseqno++;
    return g_dbvseqno;
}

/*!
\brief 登出
断开连接，清空会话存储的URL,USR,PSW,SUBP参数
*/
function dbv_logout() {
    try {
        sessionStorage.removeItem("s_dbv_url");
        sessionStorage.removeItem("s_dbv_usr");
        sessionStorage.removeItem("s_dbv_psw");
        sessionStorage.removeItem("s_dbv_subp");
        if (_dbv_ws != null)
            _dbv_ws.close();
    }
    catch (e) { }
}

/*!
\brief 发送命令
\param str 发送的字符串
*/
function dbv_send(str) {
    if (_dbv_status == false)
        return false;
    try {
        _dbv_ws.send(str);
        return true;
    }
    catch (e) {
        console.log("dbv_send Err:", e);
        return false;
    }
}

function jt_isie() {
    var Sys = {};
    var ua = navigator.userAgent.toLowerCase();
    var s;
    (s = ua.match(/rv:([\d.]+)\) like gecko/)) ? Sys.ie = s[1] :
    (s = ua.match(/msie ([\d.]+)/)) ? Sys.ie = s[1] :
    (s = ua.match(/firefox\/([\d.]+)/)) ? Sys.firefox = s[1] :
    (s = ua.match(/chrome\/([\d.]+)/)) ? Sys.chrome = s[1] :
    (s = ua.match(/opera.([\d.]+)/)) ? Sys.opera = s[1] :
    (s = ua.match(/version\/([\d.]+).*safari/)) ? Sys.safari = s[1] : 0;
    if (Sys.ie) alert("此页面不支持IE浏览器,请使用chrome或firefox");
};

