﻿/*!
\file dbv5.js
\author jiangyong
*/

function rdb_dt2str(ndt) {
    var str = "void";
    switch (ndt) {
        case 1: str = "digital"; break;
        case 2: str = "int32"; break;
        case 3: str = "float32"; break;
        case 4: str = "int64"; break;
        case 5: str = "float64"; break;
        case 6: str = "string"; break;
        case 7: str = "object"; break;
    }
    return str;
}

function rdb_str2dt(sdt) {
    var sl = sdt.toLowerCase();
    var v = 0;
    switch (sl) {
        case "digital":
            v = 1; break;
        case "int":
        case "int32":
            v = 2; break;

        case "float":
        case "float32":
            v = 3; break;

        case "int64":
        case "long":
            v = 4; break;

        case "float64":
        case "double":
            v = 5; break;

        case "string":
        case "str":
            v = 6; break;
        case "object":
        case "obj":
        case "blob":
            v = 7; break;
    }
    return v;
}

function rdb_comp2str(n) {
    var str = "no";
    switch (n) {
        case 1: str = "percent"; break;
        case 2: str = "abs"; break;
		case 3: str = "timer"; break;
		case 4: str = "extimer"; break;
    }
    return str;
}

function rdb_str2comp(s) {
    var sl = s.toLowerCase();
    var v = 0;
    switch (sl) {
        case "no":
        case "none":
            v = 0; break;

        case "per":
        case "percent":
            v = 1; break;

        case "value":
        case "abs":
            v = 2; break;        
			
		case "timer":
        case "time":
            v = 3; break;    
			
		case "extimer":
        case "extime":
            v = 4; break;        
    }
    return v;
}
