/*!
\file test_date.js 
测试 date 对象, date对象是rdbctrl实现的自定义对象。可以用来获取当前日期时间和解析字符串日期时间
至于脚本对象不能用 new关键字,直接用构造函数即可。
*/

global g_jobname = "test_date"; //在日中中显示的任务名，只是为了区分日志内容

function logflag() //日志标志，用于在日志中却分是哪个脚本产生的日志
{
	return "[" + g_jobname + "] ";
}

function run()
{
	var now = date();//当前时间
	logout("dbg",logflag() + "start");
	
	logout("dbg",logflag() + "now = " + now.to_string());
	
	var date1 = date(2019,5,6); //年，月，日
	logout("dbg",logflag() + "date(2019,5,6) = " + date1.to_string());
	
	var date2 = date(2019,5,6,12,32,24);//年，月，日，时，分，秒
	logout("dbg",logflag() + "date(2019,5,6,12,32,24) = " + date2.to_string());
	
	var date3 = date(2019,5,6,12,32,24,360);//年，月，日，时，分，秒，毫秒
	logout("dbg",logflag() + "date(2019,5,6,12,32,24,360) = " + date3.to_string());
	
	var date4 = date("2019/5/6 8:25:36");// 日期时间字符串
	logout("dbg",logflag() + "date(\"2019/5/6 8:25:36\") = " + date4.to_string());
	
	var date5 = date("2019/5/6 8:25:36.100");// 日期时间字符串，带毫秒
	logout("dbg",logflag() + "date(\"2019/5/6 8:25:36.100\") = " + date5.to_string());
	
	var date6 = date("2019-5-6 18:25:36.100");// 日期时间字符串，带毫秒
	logout("dbg",logflag() + "date(\"2019-5-6 18:25:36.100\") = " + date6.to_string());
	
	logout("dbg",logflag() + "test read only attributes");
	
	logout("dbg",logflag() + "date6.year = " + date6.year.to_string());
	logout("dbg",logflag() + "date6.mouth = " + date6.month.to_string());
	logout("dbg",logflag() + "date6.day = " + date6.day.to_string());
	logout("dbg",logflag() + "date6.hour = " + date6.hour.to_string());
	logout("dbg",logflag() + "date6.minute = " + date6.minute.to_string());
	logout("dbg",logflag() + "date6.second = " + date6.second.to_string());
	logout("dbg",logflag() + "date6.millisecond = " + date6.millisecond.to_string());
	
	//下面测试rdb时标
	logout("dbg",logflag() + "test rdbtime");
	var tagv = t_val();//创建一个标签值对象
	tagv.ti = rdb_time(); //用当前时间赋值	
	
	logout("dbg",logflag() + "tagv time = " + tagv.year.to_string() + "-" + tagv.month.to_string() + "-" + tagv.day.to_string() + " " + 
	 tagv.hour.to_string() + ":" + tagv.minute.to_string() + ":" + tagv.second.to_string() + "." + tagv.millisecond.to_string());
	
	tagv.settime(2019,5,13,14,27,52,200); //测试 settime
	logout("dbg",logflag() + "tagv time = " + tagv.year.to_string() + "-" + tagv.month.to_string() + "-" + tagv.day.to_string() + " " + 
	 tagv.hour.to_string() + ":" + tagv.minute.to_string() + ":" + tagv.second.to_string() + "." + tagv.millisecond.to_string());
	 
	var dateiso = date("2023-12-1T11:37:20.100Z");
	logout("dbg",logflag() + "dateiso.toISOString() = " + dateiso.toISOString());
	
	logout("dbg",logflag() + "rdb_time() = " + rdbtime_to_isostr(rdb_time()));

}

