﻿#pragma once
// 注意，本程序需要支持C11标准的编译器。VS2015,VS2017, GCC 4.8.3及以上
#ifdef _WIN32
#	define _CRT_SECURE_NO_WARNINGS
#	pragma warning (disable : 4996)
#	pragma warning (disable : 4200)

#	ifndef _WIN32_WINNT
#		define _WIN32_WINNT 0x0502	// 0x0502 windows2003
#	endif

#	include <process.h>
#	define WIN32_LEAN_AND_MEAN
#	include <windows.h>

#	ifndef _NOTUSE_WINSOCKET
#	include <Winsock2.h>
#	pragma comment(lib,"Ws2_32.lib")
#	endif

#else
#	include <termios.h>
#	include <unistd.h>
#	include <pthread.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <mutex>
#include <condition_variable>
#include <thread>
#include <atomic>
#include <chrono>


class cEvent
{
public:
	cEvent(bool bInitiallyOwn = false, bool bManualReset = false) :_nready(bInitiallyOwn), _bManualReset(bManualReset)
	{
	}
	bool SetEvent()
	{
		std::unique_lock<std::mutex> lck(_mtx);
		_nready = true;
		_cv.notify_one();
		return true;
	};
	bool ResetEvent()
	{
		std::unique_lock<std::mutex> lck(_mtx);
		_nready = false;
		return true;
	}
	bool Wait(int milliseconds)
	{
		std::unique_lock<std::mutex> lck(_mtx);
		if (!_nready)
			_cv.wait_for(lck, std::chrono::milliseconds(milliseconds));
		if (_nready)
		{
			if (!_bManualReset)
				_nready = false;
			return true;
		}
		return false;
	}
protected:
	bool _nready;
	bool _bManualReset;
	std::mutex _mtx;
	std::condition_variable _cv;
};

class cCritical : public std::mutex
{
public:
	cCritical() = default;
	cCritical(unsigned int ucount) {};
	inline void Lock() { lock(); }
	inline void Unlock() { unlock(); }
};

class cSafeLock
{
public:
	cSafeLock(cCritical *pLock) : _pcs(pLock)
	{
		if (_pcs)
			_pcs->Lock();
	};
	~cSafeLock() {
		if (_pcs)
			_pcs->Unlock();
	};
private:
	cCritical * _pcs;
};

#ifndef _ARM_LINUX
class cThread
{
public:
	cThread() :_bRuning(0), _bKilling(0)
	{
	}
	virtual ~cThread() {
		StopThread();
	}
protected:
	std::atomic_int	_bRuning;
	std::atomic_int	_bKilling;

	std::thread *_pthread = nullptr;
	cEvent* _pevt = nullptr;  // trigger event

	void *_pdoarg = nullptr;
	bool(*_pdojob)(void *) = nullptr; // Non-derived use, return false will stop thread    
public:
	void StartThread(cEvent* pevt, bool(*dojob)(void *) = nullptr, void*  pargs = nullptr)
	{
		if (nullptr != _pthread)
			return;
		_pevt = pevt;
		_pdojob = dojob;
		_pdoarg = pargs;
		_pthread = new std::thread(ThreadProcess, this);
	}
	void StopThread()
	{
		if (nullptr != _pthread) {
			_bKilling = 1;
			while (_bRuning)
				std::this_thread::sleep_for(std::chrono::milliseconds(100));
			_pthread->join();
			delete _pthread;
			_pthread = nullptr;
		}
	}
	inline bool IsRun() { return 0 != _bRuning; };
	inline bool Killing() { return 0 != _bKilling; };
	inline void setkill(int n) { _bKilling = n; };
private:
	static void ThreadProcess(void* pargs)
	{
		cThread* pt = (cThread*)pargs;
		pt->mainloop();
	}
public:
	void	mainloop()
	{
		OnStart();
		_bKilling = 0;
		_bRuning = 1;
		while (!_bKilling) {
			if (!_pevt || _pevt->Wait(200)) {
				if (!_pdojob)
					dojob();
				else {
					if (!_pdojob(_pdoarg))
						break;
				}
			}
			if (_pevt)
				On100msTimer();
		}
		OnStop();
		_bRuning = 0;
		_bKilling = 0;
	}
protected:
	virtual bool OnStart() { return true; };
	virtual void OnStop() { };
	virtual	void dojob() { std::this_thread::sleep_for(std::chrono::milliseconds(100)); };
	virtual void On100msTimer() { };
};
#else

#	ifndef ARM_STACK_SIZE
#		define ARM_STACK_SIZE 0x100000 // 1MB
#	endif
class cThread
{
public:
	cThread() :_bRuning(0), _bKilling(0) {
	};
	virtual ~cThread() {
		StopThread();
	}
protected:
	std::atomic_int	_bRuning;
	std::atomic_int	_bKilling;

	pthread_t   m_tid = 0;
	cEvent*		_pevt = nullptr;

	void *_pdoarg = nullptr;
	bool(*_pdojob)(void *) = nullptr; // Non-derived use, return false will stop thread		
public:
	void	StartThread(cEvent* pevt, bool(*dojob)(void *) = NULL, void*  pargs = NULL)
	{
		if (_bRuning)
			return;
		_pevt = pevt;
		_pdojob = dojob;
		_pdoarg = pargs;

		pthread_attr_t attr;
		pthread_attr_init(&attr);
		pthread_attr_setstacksize(&attr, ARM_STACK_SIZE);
		pthread_create(&m_tid, &attr, ThreadProcess, this);
		pthread_attr_destroy(&attr);
	}
	void StopThread()
	{
		if (m_tid) {
			_bKilling = 1;
			while (_bRuning)
				std::this_thread::sleep_for(std::chrono::milliseconds(100));
			pthread_join(m_tid, NULL);
			m_tid = 0;
		}
	}
	inline bool IsRun() { return 0 != _bRuning; };
	inline bool Killing() { return 0 != _bKilling; };
	inline void setkill(int n) { _bKilling = n; };
private:
	static void* ThreadProcess(void* pargs)
	{
		cThread* pt = (cThread*)pargs;
		pt->mainloop();
		return nullptr;
	}
public:
	void	mainloop()
	{
		OnStart();
		_bKilling = 0;
		_bRuning = 1;
		while (!_bKilling) {
			if (!_pevt || _pevt->Wait(200)) {
				if (!_pdojob)
					dojob();
				else {
					if (!_pdojob(_pdoarg))
						break;
				}
			}
			if (_pevt)
				On100msTimer();
		}
		OnStop();
		_bRuning = 0;
		_bKilling = 0;
	}
protected:
	virtual bool OnStart() { return true; };
	virtual void OnStop() { };
	virtual	void dojob() { std::this_thread::sleep_for(std::chrono::milliseconds(100)); };
	virtual void On100msTimer() { };
};
#endif

#define ERRHANDLE		(-1)

#ifndef MAXHANDLES
#define MAXHANDLES	64	
#endif

#ifndef MAXHANDLEVAL
#define MAXHANDLEVAL	2048
#endif

template<class T>
class tHandle
{
public:
	tHandle() {
		_next = 0;
		int i;
		for (i = 0; i < MAXHANDLES; i++) {
			_h[i].Handle = ERRHANDLE;
			_h[i].pcls = 0;
		}
	};
	~tHandle() {
		int i;
		for (i = 0; i < MAXHANDLES; i++) {
			if (_h[i].Handle != ERRHANDLE && _h[i].pcls) {
				delete _h[i].pcls;
			}
			_h[i].Handle = ERRHANDLE;
			_h[i].pcls = 0;
		}
	}

	int  CreateHandle()
	{
		cSafeLock lck(&_cs);
		int i;
		for (i = 0; i < MAXHANDLES; i++)
		{
			if (_h[i].Handle == ERRHANDLE)
			{
				_h[i].pcls = new T();
				if (_h[i].pcls)
				{
					_h[i].Handle = GetNextHandle();
					return _h[i].Handle;
				}
				else
				{
					_h[i].Handle = ERRHANDLE;
					return ERRHANDLE;
				}
			}
		}
		return ERRHANDLE;
	}

	void DelHandle(int h)
	{
		cSafeLock lck(&_cs);
		int i;
		for (i = 0; i < MAXHANDLES; i++) {
			if (_h[i].Handle == h) {
				_h[i].Handle = ERRHANDLE;
				if (_h[i].pcls) {
					delete _h[i].pcls;
					_h[i].pcls = NULL;
				}
				return;
			}
		}
	}

	T* GetClsByHandle(int h)
	{
		cSafeLock lck(&_cs);
		int i;
		for (i = 0; i < MAXHANDLES; i++) {
			if (_h[i].Handle == h)
				return _h[i].pcls;
		}
		return NULL;
	}

protected:
	int _next;
	cCritical _cs;
	struct T_I
	{
		int Handle;
		T* pcls;
	}_h[MAXHANDLES];
	int GetNextHandle()
	{
		_next++;
		if (_next > MAXHANDLEVAL)
			_next = 0;
		while (isexit(_next)) {
			_next++;
			if (_next > MAXHANDLEVAL)
				_next = 0;
		}
		return _next;
	}
	bool isexit(int h)
	{
		int i;
		for (i = 0; i < MAXHANDLES; i++)
			if (_h[i].Handle == h)
				return true;
		return false;
	}
};

template<typename _Tp, size_t _Num>
class Array {
public:
	typedef _Tp		value_type;
	typedef size_t	size_type;
	typedef _Tp*	iterator;
	Array() :_bufsize(_Num), _size(0) {
	}
protected:
	size_type _bufsize;
	size_type _size;
	value_type _data[_Num];
public:
	inline size_type size() const noexcept
	{
		return _size;
	}
	inline void clear() noexcept
	{
		_size = 0;
	}
	inline size_type capacity() const noexcept
	{
		return _bufsize;
	}
	bool add(const value_type &obj) noexcept
	{
		if (_size >= _bufsize)
			return false;
		_data[_size++] = obj;
		return true;
	}
	bool add(const value_type &obj, size_type size) noexcept
	{
		if (_size + size > _bufsize)
			return false;
		for (size_type i = 0; i < size; i++)
			_data[_size++] = obj;
		return true;
	}
	bool add(const value_type *pbuf, size_type usize = 1) noexcept
	{
		if (!usize || !pbuf)
			return true;
		if (_size + usize > _bufsize)
			return false;
		memcpy(&_data[_size], pbuf, usize * sizeof(value_type));
		_size += usize;
		return true;
	};
	inline bool push_back(const value_type& val) noexcept
	{
		return add(val);
	}
	inline void pop_back()
	{
		if (_size > 0)
			_size--;
	}
	inline value_type& operator [](size_type pos)
	{
		return _data[pos];
	}
	inline iterator begin() noexcept
	{
		return &_data[0];
	}
	inline iterator end() noexcept
	{
		return &_data[_size];
	}
	inline bool empty() const noexcept
	{
		return !_size;
	}
	inline bool full() const noexcept
	{
		return _size >= _bufsize;
	}
	void for_each(std::function<void(value_type& val)> fun) noexcept
	{
		for (size_type i = 0; i < _size; i++)
			fun(_data[i]);
	}
	void for_each(iterator first, iterator last, std::function<void(value_type& val)> fun) noexcept
	{
		while (first != last)
			fun(*first++);
	}
	inline value_type* data() noexcept
	{
		return &_data[0];
	}
	inline const value_type* data() const noexcept
	{
		return &_data[0];
	}
	bool erase(value_type &val) noexcept
	{
		for (size_type i = 0; i < _size; i++) {
			if (val == _data[i]) {
				while (i + 1 < _size) {
					_data[i] = _data[i + 1];
					i++;
				}
				_size--;
				return true;
			}
		}
		return false;
	}
	bool erase(size_type pos) noexcept
	{
		if (pos >= _size)
			return false;
		while (pos + 1 < _size) {
			_data[pos] = _data[pos + 1];
			pos++;
		}
		_size--;
		return true;
	}
	value_type* find(std::function <bool(value_type& val)> fun) {
		for (size_type i = 0; i < _size; i++) {
			if (fun(_data[i]))
				return &_data[i];
		}
		return nullptr;
	}
	inline value_type& at(size_type pos)
	{
		return _data[pos];
	}
};

