#!/bin/bash

INST_UPDATE=1
DEST_BIN_DIR="/usr/local/bin/rdb_aarch64/"
SERVICE_NAME="rdb5.service"
SERVICE_FILE="/etc/systemd/system/${SERVICE_NAME}"

if [[ ! -f ${SERVICE_FILE} ]]; then
	echo "install as new"
	INST_UPDATE=0
    mkdir -p ${DEST_BIN_DIR}
    cp -v ${SERVICE_NAME} ${SERVICE_FILE}
    systemctl enable ${SERVICE_NAME}
    systemctl daemon-reload
fi

BIN_NAME="rdb_aarch64"
SRC_BIN_FILE="${BIN_NAME}"
DEST_BIN_FILE="${DEST_BIN_DIR}${BIN_NAME}"

#if running, stop it
if [[ "XX`pidof ${BIN_NAME}`" != "XX" ]]; then
	INST_UPDATE=1
	echo "install as update"
	echo "${BIN_NAME} is running, stop it."
	systemctl stop ${SERVICE_NAME}
    echo "${SERVICE_NAME} stopped."
	sleep 2
fi

#copy bin file
cp -v ${SRC_BIN_FILE} ${DEST_BIN_DIR}
chmod +x ${DEST_BIN_FILE}

#copy other files
if [[ ${INST_UPDATE} == 0 ]]; then
	cp -v rdb_aarch64.conf ${DEST_BIN_DIR}
	cp -v httpsrv.conf ${DEST_BIN_DIR}
	cp -r rdb_http /home
	echo -e "install success."
else
	echo -e "update success."
fi

#start service
echo "start ${SERVICE_NAME}"
systemctl start ${SERVICE_NAME}
${DEST_BIN_DIR}${BIN_NAME} -status





